<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that other
 * 'pages' on your WordPress site will use a different template.
 *
 */

get_header(); ?>

<?php

	// Get content width and sidebar position
	$content_class = woodmart_get_content_class();

?>


<div class="site-content <?php echo esc_attr( $content_class ); ?>" role="main">


            <div class="ficha-maquina">
                    
                    <div class="wrapperFicha clearfix">
                
                        <div class="left">

                            <div class="titulo"> <?php echo get_the_title(); ?> </div>
                            <hr class="borde-titulo">
                            <div class="campo">
                                <?php if( get_field('tipo') ) { ?>
                                    <div class="tituloCampo">TIPO</div>
                                    <div class="valorCampo"><?php the_field('tipo'); ?></div>
                                <?php } ?>
                            </div>
                            <div class="campo">
                                <?php if( get_field('marca') ) { ?>
                                    <div class="tituloCampo">MARCA</div>
                                    <div class="valorCampo"><?php the_field('marca'); ?></div>
                                <?php } ?>
                            </div>
                            <div class="campo">
                                <?php if( get_field('modelo') ) { ?>
                                    <div class="tituloCampo">MODELO</div>
                                    <div class="valorCampo"><?php the_field('modelo'); ?></div>
                                <?php } ?>
                            </div>
                            <div class="campo">
                                <?php if( get_field('capacidad') ) { ?>
                                    <div class="tituloCampo">CAPACIDAD</div>
                                    <div class="valorCampo"><?php the_field('capacidad'); ?></div>
                                <?php } ?>
                            </div>
                            <div class="campo">
                                <?php if( get_field('observaciones') ) { ?>
                                    <div class="tituloCampo">OBSERVACIONES</div>
                                    <div class="valorCampo"><?php the_field('observaciones'); ?></div>
                                <?php } ?>
                            </div>
                            <a class="botonCotice" href="<?php echo get_home_url();?>/cotizacion">COTICE AQUÍ</a>
                        </div>
                    
                        <div class="right">
                            <div class="demo">
                                
                            <?php 
                                $images = get_field('gallery');
                                if( $images ): ?>
                                    <ul id="lightSlider"">
                                        <?php foreach( $images as $image ): ?>
                                            <li data-thumb="<?php echo esc_url($image['sizes']['thumbnail']); ?>">
                                                <a href="<?php echo esc_url($image['url']); ?>">
                                                    <img src="<?php echo esc_url($image['sizes']['large']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                                                </a>
                                                <p><?php echo esc_html($image['caption']); ?></p>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                            <?php endif; ?>

                            </div>
                        </div>

                    </div>
            </div>

<?php get_footer(); ?>